# Cash Flow Management System - Installation Guide

## Quick Start (5 Minutes)

### Step 1: Prerequisites Check
Ensure you have:
- ✅ PHP 8.2 or higher
- ✅ MySQL or MariaDB
- ✅ Composer
- ✅ Apache/Nginx web server

### Step 2: Extract Files
```bash
# Extract to your web directory
unzip cash-flow-system.zip
cd cash-flow-system
```

### Step 3: Install Dependencies
```bash
composer install
```

### Step 4: Configure Environment
```bash
# Copy environment file
cp .env.example .env

# Generate application key
php artisan key:generate
```

### Step 5: Configure Database
Edit `.env` file:
```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=cash_flow_system
DB_USERNAME=root
DB_PASSWORD=your_password
```

### Step 6: Create Database
```sql
CREATE DATABASE cash_flow_system CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

### Step 7: Run Migrations
```bash
php artisan migrate
```

### Step 8: Seed Sample Data (Optional)
```bash
php artisan db:seed
```

### Step 9: Start Server
```bash
php artisan serve
```

Visit: **http://localhost:8000**

---

## Detailed Installation Guide

### For Windows (XAMPP/WAMP)

#### 1. Install XAMPP
- Download from: https://www.apachefriends.org/
- Install with PHP 8.2+, MySQL, Apache

#### 2. Extract Project
```bash
# Copy to: C:\xampp\htdocs\cash-flow-system
```

#### 3. Install Composer
- Download from: https://getcomposer.org/
- Run installer

#### 4. Install Dependencies
```bash
cd C:\xampp\htdocs\cash-flow-system
composer install
```

#### 5. Configure
```bash
copy .env.example .env
php artisan key:generate
```

#### 6. Setup Database
- Open phpMyAdmin: http://localhost/phpmyadmin
- Create database: `cash_flow_system`
- Update .env:
```env
DB_DATABASE=cash_flow_system
DB_USERNAME=root
DB_PASSWORD=
```

#### 7. Migrate & Seed
```bash
php artisan migrate
php artisan db:seed
```

#### 8. Configure Virtual Host (Optional)
Edit: `C:\xampp\apache\conf\extra\httpd-vhost.conf`
```apache
<VirtualHost *:80>
    ServerName cashflow.local
    DocumentRoot "C:/xampp/htdocs/cash-flow-system/public"
    <Directory "C:/xampp/htdocs/cash-flow-system/public">
        Options Indexes FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

Edit: `C:\Windows\System32\drivers\etc\hosts`
```
127.0.0.1 cashflow.local
```

Restart Apache. Visit: http://cashflow.local

---

### For Linux (Ubuntu/Debian)

#### 1. Install Prerequisites
```bash
# Update system
sudo apt update && sudo apt upgrade -y

# Install PHP 8.2
sudo apt install -y php8.2 php8.2-cli php8.2-fpm php8.2-mysql php8.2-xml php8.2-mbstring php8.2-curl php8.2-zip

# Install MySQL
sudo apt install -y mysql-server

# Install Composer
curl -sS https://getcomposer.org/installer | php
sudo mv composer.phar /usr/local/bin/composer

# Install Apache/Nginx
sudo apt install -y apache2  # OR nginx
```

#### 2. Extract Project
```bash
sudo mkdir -p /var/www/cash-flow-system
sudo unzip cash-flow-system.zip -d /var/www/
cd /var/www/cash-flow-system
```

#### 3. Install Dependencies
```bash
composer install --optimize-autoloader --no-dev
```

#### 4. Configure Environment
```bash
cp .env.example .env
php artisan key:generate
```

#### 5. Setup Database
```bash
sudo mysql
```
```sql
CREATE DATABASE cash_flow_system CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
CREATE USER 'cashflow_user'@'localhost' IDENTIFIED BY 'StrongPassword123!';
GRANT ALL PRIVILEGES ON cash_flow_system.* TO 'cashflow_user'@'localhost';
FLUSH PRIVILEGES;
EXIT;
```

Update .env:
```env
DB_DATABASE=cash_flow_system
DB_USERNAME=cashflow_user
DB_PASSWORD=StrongPassword123!
```

#### 6. Run Migrations
```bash
php artisan migrate
php artisan db:seed
```

#### 7. Set Permissions
```bash
sudo chown -R www-data:www-data /var/www/cash-flow-system
sudo chmod -R 755 /var/www/cash-flow-system
sudo chmod -R 775 /var/www/cash-flow-system/storage
sudo chmod -R 775 /var/www/cash-flow-system/bootstrap/cache
```

#### 8. Configure Apache
```bash
sudo nano /etc/apache2/sites-available/cashflow.conf
```
```apache
<VirtualHost *:80>
    ServerName cashflow.yourdomain.com
    ServerAdmin admin@yourdomain.com
    DocumentRoot /var/www/cash-flow-system/public

    <Directory /var/www/cash-flow-system/public>
        Options Indexes FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>

    ErrorLog ${APACHE_LOG_DIR}/cashflow-error.log
    CustomLog ${APACHE_LOG_DIR}/cashflow-access.log combined
</VirtualHost>
```

```bash
# Enable site and rewrite module
sudo a2enmod rewrite
sudo a2ensite cashflow.conf
sudo systemctl restart apache2
```

---

### For macOS

#### 1. Install Homebrew
```bash
/bin/bash -c "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/HEAD/install.sh)"
```

#### 2. Install Prerequisites
```bash
# Install PHP
brew install php@8.2

# Install MySQL
brew install mysql
brew services start mysql

# Install Composer
brew install composer
```

#### 3. Extract & Install
```bash
cd ~/Sites  # or your preferred directory
unzip cash-flow-system.zip
cd cash-flow-system
composer install
```

#### 4. Setup Database
```bash
mysql -u root
```
```sql
CREATE DATABASE cash_flow_system;
EXIT;
```

#### 5. Configure & Run
```bash
cp .env.example .env
php artisan key:generate
# Edit .env for database settings
php artisan migrate
php artisan db:seed
php artisan serve
```

---

## Production Deployment

### Security Checklist
- [ ] Set `APP_ENV=production` in .env
- [ ] Set `APP_DEBUG=false` in .env
- [ ] Generate strong `APP_KEY`
- [ ] Use HTTPS (SSL certificate)
- [ ] Secure database credentials
- [ ] Set proper file permissions
- [ ] Enable firewall
- [ ] Regular backups

### Performance Optimization
```bash
# Cache configuration
php artisan config:cache
php artisan route:cache
php artisan view:cache

# Optimize autoloader
composer install --optimize-autoloader --no-dev

# Enable OPcache (add to php.ini)
opcache.enable=1
opcache.memory_consumption=256
opcache.max_accelerated_files=20000
```

### Backup Strategy
```bash
# Database backup
mysqldump -u username -p cash_flow_system > backup_$(date +%Y%m%d).sql

# File backup
tar -czf cashflow_files_$(date +%Y%m%d).tar.gz /var/www/cash-flow-system
```

---

## Troubleshooting

### Issue: "500 Internal Server Error"
**Solution:**
```bash
php artisan cache:clear
php artisan config:clear
chmod -R 775 storage bootstrap/cache
```

### Issue: "SQLSTATE Connection refused"
**Solution:**
- Check MySQL is running: `sudo systemctl status mysql`
- Verify credentials in .env
- Test connection: `php artisan tinker` then `DB::connection()->getPdo();`

### Issue: "Class not found"
**Solution:**
```bash
composer dump-autoload
php artisan clear-compiled
php artisan optimize
```

### Issue: "Permission denied"
**Solution:**
```bash
sudo chown -R www-data:www-data storage bootstrap/cache
sudo chmod -R 775 storage bootstrap/cache
```

### Issue: Blank page / White screen
**Solution:**
- Enable debug: Set `APP_DEBUG=true` in .env
- Check logs: `storage/logs/laravel.log`
- Verify PHP version: `php -v` (must be >= 8.2)

---

## Testing the Installation

After installation, verify everything works:

1. **Access Dashboard**: http://localhost:8000
   - Should see statistics cards
   - Quick actions section

2. **Create Company**
   - Go to Companies → Add Company
   - Fill form and save

3. **Create Project**
   - Go to Projects → Add Project
   - Link to company

4. **Create Particulars**
   - Add some Inflows (Sales, etc.)
   - Add some Outflows (Expenses, etc.)

5. **Create Cash Flow**
   - Select company, project, year
   - Select multiple months
   - Enter budget/actual values
   - Verify calculations work

6. **View Report**
   - Go to Cash Flows
   - Click "View" on any cash flow
   - Verify proper rendering

---

## Getting Help

If you encounter issues:

1. Check `storage/logs/laravel.log`
2. Enable debug mode: `APP_DEBUG=true`
3. Verify PHP version: `php -v`
4. Check database connection
5. Review file permissions

## Next Steps

After successful installation:
- Review the README.md for feature details
- Customize colors and branding
- Set up regular backups
- Configure SSL for production
- Train users on the system

---

**Congratulations! Your Cash Flow Management System is ready to use! 🎉**
