# Cash Flow Management System

A modern, responsive Laravel-based Cash Flow Management System for tracking company financial flows with Budget vs Actual comparisons.

## Features

### Core Modules
- **Companies Management**: Create and manage multiple companies
- **Projects Management**: Track projects linked to companies  
- **Particulars Management**: Define inflow/outflow items (Sales, Expenses, etc.)
- **Cash Flow Statements**: Create detailed monthly budget vs actual cash flow reports

### Dashboard
- Real-time statistics (Total Companies, Projects, Cash Flows)
- Net Cash Flow overview
- Recent cash flows listing
- Quick action shortcuts
- System analytics

### Cash Flow Features
- Multi-month budget vs actual entry (select any months)
- Dynamic particular loading based on company
- Automatic calculations (Inflows, Outflows, Net Cash Flow)
- Comprehensive cash flow history table
- View, Edit, Delete operations
- Professional statement rendering

### Design
- Modern, clean UI with gradient accents
- Fully mobile responsive (looks like a native app on mobile)
- Bottom navigation bar for mobile devices
- Touch-optimized forms and interactions
- DataTables integration for advanced filtering
- Bootstrap 5 with custom styling

## Technology Stack

- **Backend**: Laravel 11
- **Frontend**: Bootstrap 5, jQuery
- **Database**: MySQL
- **Icons**: Bootstrap Icons
- **Tables**: DataTables

## Installation

### Prerequisites
- PHP >= 8.2
- Composer
- MySQL/MariaDB
- Node.js & NPM (optional, for asset compilation)

### Step 1: Clone/Extract Project
```bash
# Extract the project to your web directory
cd /path/to/your/webserver
```

### Step 2: Install Dependencies
```bash
composer install
```

### Step 3: Environment Configuration
```bash
# Copy environment file
cp .env.example .env

# Generate application key
php artisan key:generate

# Configure database in .env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=cash_flow_system
DB_USERNAME=your_username
DB_PASSWORD=your_password
```

### Step 4: Create Database
```sql
CREATE DATABASE cash_flow_system;
```

### Step 5: Run Migrations
```bash
php artisan migrate
```

### Step 6: Seed Sample Data (Optional)
```bash
php artisan db:seed
```

### Step 7: Start Development Server
```bash
php artisan serve
```

Visit: `http://localhost:8000`

## Production Deployment

### Apache Configuration
```apache
<VirtualHost *:80>
    ServerName yourdomain.com
    DocumentRoot /path/to/cash-flow-system/public

    <Directory /path/to/cash-flow-system/public>
        AllowOverride All
        Require all granted
    </Directory>

    ErrorLog ${APACHE_LOG_DIR}/cash-flow-error.log
    CustomLog ${APACHE_LOG_DIR}/cash-flow-access.log combined
</VirtualHost>
```

### Nginx Configuration
```nginx
server {
    listen 80;
    server_name yourdomain.com;
    root /path/to/cash-flow-system/public;

    add_header X-Frame-Options "SAMEORIGIN";
    add_header X-Content-Type-Options "nosniff";

    index index.php;

    charset utf-8;

    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.2-fpm.sock;
        fastcgi_param SCRIPT_FILENAME $realpath_root$fastcgi_script_name;
        include fastcgi_params;
    }

    location ~ /\.(?!well-known).* {
        deny all;
    }
}
```

### Production Optimization
```bash
# Cache configuration
php artisan config:cache

# Cache routes
php artisan route:cache

# Optimize autoloader
composer install --optimize-autoloader --no-dev

# Set proper permissions
chmod -R 755 storage bootstrap/cache
chown -R www-data:www-data storage bootstrap/cache
```

## Usage Guide

### 1. Create a Company
- Navigate to Companies → Add Company
- Enter company name and description
- Save

### 2. Create Projects
- Navigate to Projects → Add Project
- Select company
- Enter project details
- Save

### 3. Define Particulars
- Navigate to Particulars → Add Particular
- Select company
- Choose type (Inflow/Outflow)
- Examples: Sales, Insurance Claims (Inflows), Salaries, Rent (Outflows)
- Save

### 4. Create Cash Flow Statement
- Navigate to Cash Flows → Create Cash Flow
- Select Company, Project, Year
- Select months (Hold Ctrl/Cmd for multiple)
- Click "Load Particulars & Generate Form"
- Enter Budget and Actual values for each month
- Calculations happen automatically
- Submit

### 5. View Cash Flow
- View detailed cash flow statements
- See monthly breakdowns
- Total calculations
- Budget vs Actual comparisons

## Database Schema

### Companies
- id, name, description, timestamps

### Projects
- id, company_id, name, status, description, timestamps

### Particulars
- id, company_id, type (Inflow/Outflow), name, status, description, timestamps

### Cash Flows
- id, company_id, project_id, year, created_by, timestamps

### Cash Flow Items
- id, cash_flow_id, particular_id, particular_name, type, month, budget, actual, timestamps

## API Endpoints

### Public Routes
- `GET /` - Dashboard
- `GET /companies` - Companies listing
- `GET /projects` - Projects listing
- `GET /particulars` - Particulars listing
- `GET /cash-flows` - Cash flows listing

### API Routes
- `GET /api/projects/company/{id}` - Get projects by company
- `GET /api/particulars/company/{id}` - Get particulars by company

## Mobile Responsiveness

The system is fully optimized for mobile devices:
- Responsive tables with horizontal scrolling
- Bottom navigation bar (app-like on mobile)
- Touch-optimized buttons and forms
- Collapsible sidebar
- Optimized font sizes
- Mobile-first design approach

## Customization

### Colors
Edit CSS variables in `resources/views/layouts/app.blade.php`:
```css
:root {
    --primary-color: #4f46e5;
    --secondary-color: #06b6d4;
    --success-color: #10b981;
    --danger-color: #ef4444;
}
```

### Logo
Replace in sidebar section:
```html
<h4><i class="bi bi-cash-coin"></i> Your Company Name</h4>
```

## Troubleshooting

### Database Connection Error
- Check `.env` database credentials
- Ensure MySQL service is running
- Verify database exists

### Permission Errors
```bash
chmod -R 755 storage bootstrap/cache
chown -R www-data:www-data storage bootstrap/cache
```

### Blank Page
```bash
php artisan cache:clear
php artisan config:clear
php artisan route:clear
```

## Support

For issues or questions:
- Check Laravel logs: `storage/logs/laravel.log`
- Enable debug mode: Set `APP_DEBUG=true` in `.env`

## Security

- Change `APP_KEY` in production
- Never commit `.env` file
- Use HTTPS in production
- Keep Laravel updated
- Validate all inputs
- Use CSRF protection (included)

## License

This project is proprietary software developed for specific client use.

## Credits

- **Framework**: Laravel 11
- **UI**: Bootstrap 5
- **Icons**: Bootstrap Icons
- **Tables**: DataTables
- **Developer**: SoftSuite Technologies

## Version

- **Version**: 1.0.0
- **Release Date**: December 2024
- **Laravel Version**: 11.x
- **PHP Version**: >= 8.2
