# 🔧 SERVER TROUBLESHOOTING GUIDE

## Your Current Issue: "Please provide a valid cache path"

This error occurs because the storage directories don't exist or have wrong permissions.

---

## QUICK FIX (Copy and paste these commands on your server):

```bash
# Navigate to your project
cd ~/public_html

# Create all required directories
mkdir -p storage/framework/cache/data
mkdir -p storage/framework/sessions
mkdir -p storage/framework/views
mkdir -p storage/logs
mkdir -p storage/app/public
mkdir -p bootstrap/cache

# Set proper permissions
chmod -R 775 storage
chmod -R 775 bootstrap/cache

# Create .env file if missing
if [ ! -f .env ]; then
    cat > .env << 'EOF'
APP_NAME="Cash Flow System"
APP_ENV=production
APP_KEY=
APP_DEBUG=false
APP_URL=https://cashinflow.softsuitetech.com

LOG_CHANNEL=stack
LOG_LEVEL=debug

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=cashinflow_db
DB_USERNAME=cashinflow_user
DB_PASSWORD=YOUR_DB_PASSWORD_HERE

CACHE_DRIVER=file
SESSION_DRIVER=file
SESSION_LIFETIME=120
FILESYSTEM_DISK=local
QUEUE_CONNECTION=sync
EOF
fi

# Generate application key
php artisan key:generate --force

# Clear and cache
php artisan cache:clear
php artisan config:clear
php artisan config:cache
php artisan route:cache
```

---

## STEP-BY-STEP FIX:

### Step 1: Create .env file
```bash
cd ~/public_html
nano .env
```

Paste this content:
```
APP_NAME="Cash Flow System"
APP_ENV=production
APP_KEY=
APP_DEBUG=false
APP_URL=https://cashinflow.softsuitetech.com

LOG_CHANNEL=stack
LOG_LEVEL=debug

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=cashinflow_db
DB_USERNAME=cashinflow_user
DB_PASSWORD=YOUR_ACTUAL_PASSWORD

CACHE_DRIVER=file
SESSION_DRIVER=file
SESSION_LIFETIME=120
FILESYSTEM_DISK=local
QUEUE_CONNECTION=sync
```

Save: `Ctrl+X`, then `Y`, then `Enter`

### Step 2: Generate App Key
```bash
php artisan key:generate --force
```

### Step 3: Create Storage Directories
```bash
mkdir -p storage/framework/{cache/data,sessions,views}
mkdir -p storage/{logs,app/public}
mkdir -p bootstrap/cache
```

### Step 4: Set Permissions
```bash
chmod -R 775 storage
chmod -R 775 bootstrap/cache
```

### Step 5: Clear Caches
```bash
php artisan cache:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear
```

### Step 6: Cache for Production
```bash
php artisan config:cache
php artisan route:cache
```

---

## UPDATE YOUR .env FILE

You need to update these values in your .env:

```bash
nano .env
```

Change these lines to match your actual database:
```
DB_DATABASE=cashinflow_db          # Your actual database name
DB_USERNAME=cashinflow_user        # Your actual database username
DB_PASSWORD=your_actual_password   # Your actual database password
```

---

## IF YOU GET "APP_KEY" ERROR:

Your .env file is missing or APP_KEY is empty.

**Solution:**
```bash
# Make sure .env exists
ls -la .env

# If it doesn't exist, create it
cp env.example.txt .env

# OR manually create it
nano .env
# Paste the content from above

# Then generate key
php artisan key:generate --force
```

---

## VERIFY IT'S WORKING:

```bash
# Check if directories exist
ls -la storage/framework/
ls -la bootstrap/cache/

# Check permissions (should show 775 or 777)
stat -c "%a" storage/
stat -c "%a" bootstrap/cache/

# Check .env exists
cat .env | head -5

# Test application
php artisan about
```

---

## IF WEBSITE STILL SHOWS ERROR:

### Check Apache/Server Configuration

Your public folder should be: `/home/cashinflow/public_html/public`

**Update .htaccess in public folder:**
```bash
cd ~/public_html/public
nano .htaccess
```

Make sure it contains:
```apache
<IfModule mod_rewrite.c>
    <IfModule mod_negotiation.c>
        Options -MultiViews -Indexes
    </IfModule>

    RewriteEngine On

    # Handle Authorization Header
    RewriteCond %{HTTP:Authorization} .
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]

    # Redirect Trailing Slashes If Not A Folder...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_URI} (.+)/$
    RewriteRule ^ %1 [L,R=301]

    # Send Requests To Front Controller...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteRule ^ index.php [L]
</IfModule>
```

---

## CHECKING YOUR SETUP:

### 1. Verify File Structure:
```bash
cd ~/public_html
tree -L 2 -d
```

Should show:
```
.
├── app
├── bootstrap
│   └── cache
├── config
├── database
├── public         # <-- Your web root should point here
├── resources
├── routes
├── storage
│   ├── app
│   ├── framework
│   └── logs
└── vendor
```

### 2. Verify Permissions:
```bash
ls -la storage/
ls -la bootstrap/cache/
```

Should show: `drwxrwxr-x` (775 permissions)

### 3. Check .env file:
```bash
cat .env
```

Should show APP_KEY filled in (not empty)

---

## CPANEL CONFIGURATION:

If using cPanel, make sure:

1. **Document Root** is set to: `/home/cashinflow/public_html/public`
2. **PHP Version** is 8.2 or higher
3. **Extensions enabled**:
   - mysqli
   - pdo_mysql
   - mbstring
   - xml
   - curl

---

## COMPLETE REINSTALL (If nothing works):

```bash
# Backup database if you have data
mysqldump -u cashinflow_user -p cashinflow_db > backup.sql

# Remove old files
cd ~
rm -rf public_html/*

# Re-extract the project
# (upload and extract the zip again)

# Then run the fix script
cd ~/public_html
bash fix.sh

# Or manually:
mkdir -p storage/framework/{cache/data,sessions,views}
mkdir -p storage/{logs,app/public}
mkdir -p bootstrap/cache
chmod -R 775 storage bootstrap/cache
cp env.example.txt .env
nano .env  # Edit database credentials
php artisan key:generate --force
php artisan config:cache
php artisan route:cache
php artisan migrate
php artisan db:seed
```

---

## TESTING YOUR FIX:

After running the fix, test:

```bash
# 1. Test artisan works
php artisan about

# 2. Test database connection
php artisan migrate:status

# 3. Visit your website
# https://cashinflow.softsuitetech.com/public/
```

---

## COMMON ISSUES & SOLUTIONS:

### Issue: "file_get_contents(.env): Failed to open stream"
**Solution:** .env file missing
```bash
cp env.example.txt .env
php artisan key:generate --force
```

### Issue: "Please provide a valid cache path"
**Solution:** Storage directories missing
```bash
mkdir -p storage/framework/{cache/data,sessions,views}
chmod -R 775 storage
```

### Issue: "Permission denied"
**Solution:** Wrong permissions
```bash
chmod -R 775 storage bootstrap/cache
chown -R your_user:your_user storage bootstrap/cache
```

### Issue: "Class not found"
**Solution:** Autoload needs regenerating
```bash
composer dump-autoload
php artisan clear-compiled
php artisan optimize
```

---

## CONTACT INFORMATION:

If you're still having issues after trying these fixes:

1. Check `storage/logs/laravel.log` for detailed errors:
   ```bash
   tail -50 storage/logs/laravel.log
   ```

2. Enable debug mode temporarily:
   ```bash
   nano .env
   # Change: APP_DEBUG=true
   # Save and visit site to see detailed error
   # REMEMBER to set back to false after fixing!
   ```

3. Check server error logs:
   ```bash
   tail -50 /home/cashinflow/logs/error_log
   ```

---

## SUCCESS CHECKLIST:

After fixes, verify:
- [ ] .env file exists and has APP_KEY
- [ ] storage/ directory exists with proper structure
- [ ] bootstrap/cache/ directory exists
- [ ] Permissions are 775 on storage/ and bootstrap/cache/
- [ ] Database credentials are correct in .env
- [ ] php artisan about shows no errors
- [ ] Website loads without cache error

---

**Your site should now work!** 🎉

Visit: https://cashinflow.softsuitetech.com/public/
(Remove /public from URL if document root is set correctly)
