<?php

namespace App\Http\Controllers;

use App\Models\Company;
use App\Models\Project;
use App\Models\CashFlow;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        $totalCompanies = Company::count();
        $totalProjects = Project::count();
        $totalCashFlows = CashFlow::count();
        
        $recentCashFlows = CashFlow::with(['company', 'project'])
            ->latest()
            ->take(5)
            ->get();
        
        $netCashFlow = 0;
        foreach (CashFlow::all() as $cashFlow) {
            $totals = $cashFlow->getMonthlyTotals();
            foreach ($totals as $monthTotal) {
                $netCashFlow += $monthTotal['net_actual'];
            }
        }

        return view('dashboard.index', compact(
            'totalCompanies',
            'totalProjects',
            'totalCashFlows',
            'recentCashFlows',
            'netCashFlow'
        ));
    }
}
