<?php

namespace App\Http\Controllers;

use App\Models\Particular;
use App\Models\Company;
use Illuminate\Http\Request;

class ParticularController extends Controller
{
    public function index()
    {
        $particulars = Particular::with('company')->latest()->get();
        return view('particulars.index', compact('particulars'));
    }

    public function create()
    {
        $companies = Company::all();
        return view('particulars.create', compact('companies'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'company_id' => 'required|exists:companies,id',
            'type' => 'required|in:Inflow,Outflow',
            'name' => 'required|string|max:255',
            'status' => 'required|in:Active,Inactive',
            'description' => 'nullable|string',
        ]);

        Particular::create($validated);

        return redirect()->route('particulars.index')
            ->with('success', 'Particular created successfully.');
    }

    public function edit(Particular $particular)
    {
        $companies = Company::all();
        return view('particulars.edit', compact('particular', 'companies'));
    }

    public function update(Request $request, Particular $particular)
    {
        $validated = $request->validate([
            'company_id' => 'required|exists:companies,id',
            'type' => 'required|in:Inflow,Outflow',
            'name' => 'required|string|max:255',
            'status' => 'required|in:Active,Inactive',
            'description' => 'nullable|string',
        ]);

        $particular->update($validated);

        return redirect()->route('particulars.index')
            ->with('success', 'Particular updated successfully.');
    }

    public function destroy(Particular $particular)
    {
        $particular->delete();

        return redirect()->route('particulars.index')
            ->with('success', 'Particular deleted successfully.');
    }

    public function getByCompany($companyId)
    {
        $particulars = Particular::where('company_id', $companyId)
            ->where('status', 'Active')
            ->get()
            ->groupBy('type');
        
        return response()->json([
            'inflows' => $particulars->get('Inflow', collect()),
            'outflows' => $particulars->get('Outflow', collect()),
        ]);
    }
}
