<?php

namespace App\Http\Controllers;

use App\Models\Project;
use App\Models\Company;
use Illuminate\Http\Request;

class ProjectController extends Controller
{
    public function index()
    {
        $projects = Project::with('company')->latest()->get();
        return view('projects.index', compact('projects'));
    }

    public function create()
    {
        $companies = Company::all();
        return view('projects.create', compact('companies'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'company_id' => 'required|exists:companies,id',
            'name' => 'required|string|max:255',
            'status' => 'required|in:Active,Inactive',
            'description' => 'nullable|string',
        ]);

        Project::create($validated);

        return redirect()->route('projects.index')
            ->with('success', 'Project created successfully.');
    }

    public function edit(Project $project)
    {
        $companies = Company::all();
        return view('projects.edit', compact('project', 'companies'));
    }

    public function update(Request $request, Project $project)
    {
        $validated = $request->validate([
            'company_id' => 'required|exists:companies,id',
            'name' => 'required|string|max:255',
            'status' => 'required|in:Active,Inactive',
            'description' => 'nullable|string',
        ]);

        $project->update($validated);

        return redirect()->route('projects.index')
            ->with('success', 'Project updated successfully.');
    }

    public function destroy(Project $project)
    {
        $project->delete();

        return redirect()->route('projects.index')
            ->with('success', 'Project deleted successfully.');
    }

    public function getByCompany($companyId)
    {
        $projects = Project::where('company_id', $companyId)
            ->where('status', 'Active')
            ->get();
        return response()->json($projects);
    }
}
