<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class CashFlow extends Model
{
    protected $fillable = ['company_id', 'project_id', 'year', 'created_by'];

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    public function project(): BelongsTo
    {
        return $this->belongsTo(Project::class);
    }

    public function items(): HasMany
    {
        return $this->hasMany(CashFlowItem::class);
    }

    public function getMonthlyTotals()
    {
        $totals = [];
        for ($month = 1; $month <= 12; $month++) {
            $monthItems = $this->items()->where('month', $month)->get();
            
            $inflows = $monthItems->where('type', 'Inflow')->sum('budget');
            $inflowsActual = $monthItems->where('type', 'Inflow')->sum('actual');
            $outflows = $monthItems->where('type', 'Outflow')->sum('budget');
            $outflowsActual = $monthItems->where('type', 'Outflow')->sum('actual');
            
            $totals[$month] = [
                'inflow_budget' => $inflows,
                'inflow_actual' => $inflowsActual,
                'outflow_budget' => $outflows,
                'outflow_actual' => $outflowsActual,
                'net_budget' => $inflows - $outflows,
                'net_actual' => $inflowsActual - $outflowsActual,
            ];
        }
        return $totals;
    }
}
