<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CashFlowItem extends Model
{
    protected $fillable = [
        'cash_flow_id',
        'particular_id',
        'particular_name',
        'type',
        'month',
        'budget',
        'actual'
    ];

    protected $casts = [
        'budget' => 'decimal:2',
        'actual' => 'decimal:2',
    ];

    public function cashFlow(): BelongsTo
    {
        return $this->belongsTo(CashFlow::class);
    }

    public function particular(): BelongsTo
    {
        return $this->belongsTo(Particular::class);
    }
}
