#!/bin/bash

# Complete Fix Script for 405 Error and All Issues
# Run this on your server: bash complete-fix.sh

echo "================================================"
echo "Cash Flow System - Complete Fix"
echo "================================================"
echo ""

cd ~/public_html

echo "Step 1: Clearing all caches..."
php artisan cache:clear 2>/dev/null
php artisan config:clear 2>/dev/null
php artisan route:clear 2>/dev/null
php artisan view:clear 2>/dev/null
php artisan clear-compiled 2>/dev/null
echo "✅ Caches cleared"

echo ""
echo "Step 2: Checking routes file..."
if [ ! -f routes/web.php ]; then
    echo "❌ routes/web.php is missing! Creating it..."
    mkdir -p routes
    cat > routes/web.php << 'EOFROUTES'
<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\ParticularController;
use App\Http\Controllers\CashFlowController;

Route::get('/', [DashboardController::class, 'index'])->name('dashboard');

Route::resource('companies', CompanyController::class);
Route::resource('projects', ProjectController::class);
Route::resource('particulars', ParticularController::class);
Route::resource('cash-flows', CashFlowController::class);

Route::get('/api/projects/company/{companyId}', [ProjectController::class, 'getByCompany']);
Route::get('/api/particulars/company/{companyId}', [ParticularController::class, 'getByCompany']);
EOFROUTES
    echo "✅ routes/web.php created"
else
    echo "✅ routes/web.php exists"
fi

echo ""
echo "Step 3: Regenerating autoload..."
composer dump-autoload
echo "✅ Autoload regenerated"

echo ""
echo "Step 4: Optimizing application..."
php artisan optimize:clear
php artisan optimize
echo "✅ Optimized"

echo ""
echo "Step 5: Setting proper permissions..."
chmod -R 775 storage bootstrap/cache
echo "✅ Permissions set"

echo ""
echo "Step 6: Verifying .env configuration..."
if grep -q "APP_KEY=base64:" .env; then
    echo "✅ APP_KEY is set"
else
    echo "⚠️  Generating APP_KEY..."
    php artisan key:generate --force
fi

echo ""
echo "Step 7: Checking public/.htaccess..."
if [ ! -f public/.htaccess ]; then
    echo "❌ public/.htaccess is missing! Creating it..."
    cat > public/.htaccess << 'EOFHTACCESS'
<IfModule mod_rewrite.c>
    <IfModule mod_negotiation.c>
        Options -MultiViews -Indexes
    </IfModule>

    RewriteEngine On

    # Handle Authorization Header
    RewriteCond %{HTTP:Authorization} .
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]

    # Redirect Trailing Slashes If Not A Folder...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_URI} (.+)/$
    RewriteRule ^ %1 [L,R=301]

    # Send Requests To Front Controller...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteRule ^ index.php [L]
</IfModule>
EOFHTACCESS
    echo "✅ public/.htaccess created"
else
    echo "✅ public/.htaccess exists"
fi

echo ""
echo "Step 8: Testing artisan commands..."
php artisan about > /dev/null 2>&1
if [ $? -eq 0 ]; then
    echo "✅ Laravel is working"
else
    echo "❌ Laravel has issues. Check logs."
fi

echo ""
echo "================================================"
echo "✅ Complete Fix Applied!"
echo "================================================"
echo ""
echo "Your application should now work!"
echo "Visit: https://cashinflow.softsuitetech.com/public/"
echo ""
echo "If you still see errors:"
echo "1. Check storage/logs/laravel.log"
echo "2. Enable debug: Set APP_DEBUG=true in .env"
echo "3. Visit site to see detailed error"
echo ""
