<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('cash_flow_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('cash_flow_id')->constrained()->onDelete('cascade');
            $table->foreignId('particular_id')->constrained()->onDelete('cascade');
            $table->string('particular_name');
            $table->enum('type', ['Inflow', 'Outflow']);
            $table->integer('month');
            $table->decimal('budget', 15, 2)->default(0);
            $table->decimal('actual', 15, 2)->default(0);
            $table->timestamps();
            
            $table->index(['cash_flow_id', 'particular_id', 'month']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('cash_flow_items');
    }
};
