<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Company;
use App\Models\Project;
use App\Models\Particular;
use App\Models\CashFlow;
use App\Models\CashFlowItem;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        // Create Sample Companies
        $company1 = Company::create([
            'name' => 'Tech Solutions Inc.',
            'description' => 'Leading technology solutions provider specializing in software development and IT consulting services.'
        ]);

        $company2 = Company::create([
            'name' => 'Global Manufacturing Ltd.',
            'description' => 'International manufacturing company producing industrial equipment and machinery.'
        ]);

        // Create Projects for Company 1
        $project1 = Project::create([
            'company_id' => $company1->id,
            'name' => 'Mobile App Development',
            'status' => 'Active',
            'description' => 'Development of cross-platform mobile application for e-commerce'
        ]);

        $project2 = Project::create([
            'company_id' => $company1->id,
            'name' => 'Cloud Migration Project',
            'status' => 'Active',
            'description' => 'Migration of legacy systems to cloud infrastructure'
        ]);

        // Create Projects for Company 2
        $project3 = Project::create([
            'company_id' => $company2->id,
            'name' => 'Factory Expansion',
            'status' => 'Active',
            'description' => 'Expansion of manufacturing facility in Multan'
        ]);

        // Create Particulars (Inflows) for Company 1
        $p1 = Particular::create([
            'company_id' => $company1->id,
            'type' => 'Inflow',
            'name' => 'Sales Revenue',
            'status' => 'Active',
            'description' => 'Revenue from software sales and services'
        ]);

        $p2 = Particular::create([
            'company_id' => $company1->id,
            'type' => 'Inflow',
            'name' => 'Consulting Income',
            'status' => 'Active',
            'description' => 'Income from IT consulting services'
        ]);

        $p3 = Particular::create([
            'company_id' => $company1->id,
            'type' => 'Inflow',
            'name' => 'Investment Returns',
            'status' => 'Active',
            'description' => 'Returns from company investments'
        ]);

        // Create Particulars (Outflows) for Company 1
        $p4 = Particular::create([
            'company_id' => $company1->id,
            'type' => 'Outflow',
            'name' => 'Employee Salaries',
            'status' => 'Active',
            'description' => 'Monthly salary payments to employees'
        ]);

        $p5 = Particular::create([
            'company_id' => $company1->id,
            'type' => 'Outflow',
            'name' => 'Office Rent',
            'status' => 'Active',
            'description' => 'Monthly office space rental'
        ]);

        $p6 = Particular::create([
            'company_id' => $company1->id,
            'type' => 'Outflow',
            'name' => 'Marketing Expenses',
            'status' => 'Active',
            'description' => 'Digital marketing and advertising costs'
        ]);

        $p7 = Particular::create([
            'company_id' => $company1->id,
            'type' => 'Outflow',
            'name' => 'Utility Bills',
            'status' => 'Active',
            'description' => 'Electricity, water, and internet bills'
        ]);

        // Create Particulars for Company 2
        Particular::create([
            'company_id' => $company2->id,
            'type' => 'Inflow',
            'name' => 'Product Sales',
            'status' => 'Active',
            'description' => 'Revenue from manufactured goods'
        ]);

        Particular::create([
            'company_id' => $company2->id,
            'type' => 'Outflow',
            'name' => 'Raw Materials',
            'status' => 'Active',
            'description' => 'Purchase of raw materials for production'
        ]);

        Particular::create([
            'company_id' => $company2->id,
            'type' => 'Outflow',
            'name' => 'Labor Costs',
            'status' => 'Active',
            'description' => 'Factory worker wages'
        ]);

        // Create a Sample Cash Flow for Project 1
        $cashFlow = CashFlow::create([
            'company_id' => $company1->id,
            'project_id' => $project1->id,
            'year' => 2025,
            'created_by' => 'System Admin'
        ]);

        // Create Cash Flow Items for 5 months (Jan-May)
        $months = [1, 2, 3, 4, 5];
        
        foreach ($months as $month) {
            // Inflow items
            CashFlowItem::create([
                'cash_flow_id' => $cashFlow->id,
                'particular_id' => $p1->id,
                'particular_name' => $p1->name,
                'type' => 'Inflow',
                'month' => $month,
                'budget' => 50000 + ($month * 2000),
                'actual' => 48000 + ($month * 2500)
            ]);

            CashFlowItem::create([
                'cash_flow_id' => $cashFlow->id,
                'particular_id' => $p2->id,
                'particular_name' => $p2->name,
                'type' => 'Inflow',
                'month' => $month,
                'budget' => 30000 + ($month * 1000),
                'actual' => 32000 + ($month * 800)
            ]);

            CashFlowItem::create([
                'cash_flow_id' => $cashFlow->id,
                'particular_id' => $p3->id,
                'particular_name' => $p3->name,
                'type' => 'Inflow',
                'month' => $month,
                'budget' => 5000,
                'actual' => 5200
            ]);

            // Outflow items
            CashFlowItem::create([
                'cash_flow_id' => $cashFlow->id,
                'particular_id' => $p4->id,
                'particular_name' => $p4->name,
                'type' => 'Outflow',
                'month' => $month,
                'budget' => 40000,
                'actual' => 40000
            ]);

            CashFlowItem::create([
                'cash_flow_id' => $cashFlow->id,
                'particular_id' => $p5->id,
                'particular_name' => $p5->name,
                'type' => 'Outflow',
                'month' => $month,
                'budget' => 15000,
                'actual' => 15000
            ]);

            CashFlowItem::create([
                'cash_flow_id' => $cashFlow->id,
                'particular_id' => $p6->id,
                'particular_name' => $p6->name,
                'type' => 'Outflow',
                'month' => $month,
                'budget' => 8000 + ($month * 500),
                'actual' => 7500 + ($month * 600)
            ]);

            CashFlowItem::create([
                'cash_flow_id' => $cashFlow->id,
                'particular_id' => $p7->id,
                'particular_name' => $p7->name,
                'type' => 'Outflow',
                'month' => $month,
                'budget' => 3000,
                'actual' => 3200
            ]);
        }

        echo "✅ Database seeded successfully!\n";
        echo "📊 Created:\n";
        echo "   - 2 Companies\n";
        echo "   - 3 Projects\n";
        echo "   - 10 Particulars\n";
        echo "   - 1 Sample Cash Flow (5 months of data)\n";
        echo "\n🔐 You can now login and explore the system!\n";
    }
}
