#!/bin/bash

# Quick Fix Script for Cash Flow System
# Run this on your server to fix missing files and permissions

echo "================================================"
echo "Cash Flow System - Quick Fix"
echo "================================================"
echo ""

# Create .env file from example
if [ ! -f .env ]; then
    echo "Creating .env file..."
    if [ -f .env.example ]; then
        cp .env.example .env
        echo "✅ .env created from .env.example"
    elif [ -f env.example.txt ]; then
        cp env.example.txt .env
        echo "✅ .env created from env.example.txt"
    else
        echo "❌ No .env.example found. Creating basic .env..."
        cat > .env << 'EOF'
APP_NAME="Cash Flow System"
APP_ENV=production
APP_KEY=
APP_DEBUG=false
APP_URL=https://cashinflow.softsuitetech.com

LOG_CHANNEL=stack
LOG_LEVEL=debug

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=cashinflow_db
DB_USERNAME=cashinflow_user
DB_PASSWORD=your_password_here

BROADCAST_DRIVER=log
CACHE_DRIVER=file
FILESYSTEM_DISK=local
QUEUE_CONNECTION=sync
SESSION_DRIVER=file
SESSION_LIFETIME=120
EOF
        echo "✅ Basic .env file created"
    fi
else
    echo "ℹ️  .env file already exists"
fi

# Create necessary directories
echo ""
echo "Creating required directories..."
mkdir -p storage/framework/cache/data
mkdir -p storage/framework/sessions
mkdir -p storage/framework/views
mkdir -p storage/logs
mkdir -p storage/app/public
mkdir -p bootstrap/cache

# Create .gitignore files to keep directories
touch storage/framework/cache/data/.gitignore
touch storage/framework/sessions/.gitignore
touch storage/framework/views/.gitignore
touch storage/logs/.gitignore
touch storage/app/public/.gitignore
touch bootstrap/cache/.gitignore

echo "✅ Directories created"

# Set proper permissions
echo ""
echo "Setting permissions..."
chmod -R 775 storage
chmod -R 775 bootstrap/cache
echo "✅ Permissions set"

# Generate application key
echo ""
echo "Generating application key..."
php artisan key:generate --force
echo "✅ Key generated"

# Clear all caches
echo ""
echo "Clearing caches..."
php artisan cache:clear 2>/dev/null || true
php artisan config:clear 2>/dev/null || true
php artisan route:clear 2>/dev/null || true
php artisan view:clear 2>/dev/null || true
echo "✅ Caches cleared"

# Optimize for production
echo ""
echo "Optimizing for production..."
php artisan config:cache
php artisan route:cache
echo "✅ Optimized"

echo ""
echo "================================================"
echo "✅ Fix Complete!"
echo "================================================"
echo ""
echo "Next steps:"
echo "1. Edit .env file with your database credentials"
echo "2. Run: php artisan migrate"
echo "3. Run: php artisan db:seed (optional, for sample data)"
echo ""
echo "Your application should now work!"
