@extends('layouts.app')

@section('title', 'Cash Flows')
@section('page-title', 'Cash Flow Management')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="table-card">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h5 class="mb-0">Cash Flow History</h5>
                <a href="{{ route('cash-flows.create') }}" class="btn btn-primary-custom btn-custom">
                    <i class="bi bi-plus-circle me-2"></i>Create Cash Flow
                </a>
            </div>

            @if($cashFlows->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover" id="cashFlowsTable">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Company</th>
                                <th>Project</th>
                                <th>Year</th>
                                <th>Created By</th>
                                <th>Created At</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($cashFlows as $cashFlow)
                            <tr>
                                <td><strong>#{{ $cashFlow->id }}</strong></td>
                                <td>{{ $cashFlow->company->name }}</td>
                                <td>{{ $cashFlow->project->name }}</td>
                                <td><span class="badge bg-primary">{{ $cashFlow->year }}</span></td>
                                <td>{{ $cashFlow->created_by ?? 'Admin' }}</td>
                                <td>{{ $cashFlow->created_at->format('M d, Y h:i A') }}</td>
                                <td>
                                    <a href="{{ route('cash-flows.show', $cashFlow) }}" class="btn btn-sm btn-info" title="View">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="{{ route('cash-flows.edit', $cashFlow) }}" class="btn btn-sm btn-warning" title="Edit">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <form action="{{ route('cash-flows.destroy', $cashFlow) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this cash flow?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-graph-up-arrow" style="font-size: 3rem; color: #cbd5e1;"></i>
                    <p class="text-muted mt-3">No cash flows created yet</p>
                    <a href="{{ route('cash-flows.create') }}" class="btn btn-primary-custom btn-custom mt-2">
                        <i class="bi bi-plus-circle me-2"></i>Create Your First Cash Flow
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('#cashFlowsTable').DataTable({
            responsive: true,
            order: [[0, 'desc']],
            pageLength: 10,
            language: {
                search: "Search cash flows:"
            }
        });
    });
</script>
@endpush
