@extends('layouts.app')

@section('title', 'View Cash Flow')
@section('page-title', 'Cash Flow Statement')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="table-card">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <div>
                    <h5 class="mb-1">Cash Flow Statement #{{ $cashFlow->id }}</h5>
                    <p class="text-muted mb-0">
                        <strong>{{ $cashFlow->company->name }}</strong> - {{ $cashFlow->project->name }} ({{ $cashFlow->year }})
                    </p>
                </div>
                <div class="d-flex gap-2">
                    <a href="{{ route('cash-flows.edit', $cashFlow) }}" class="btn btn-warning btn-custom">
                        <i class="bi bi-pencil me-2"></i>Edit
                    </a>
                    <a href="{{ route('cash-flows.index') }}" class="btn btn-secondary btn-custom">
                        <i class="bi bi-arrow-left me-2"></i>Back
                    </a>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="p-3 bg-light rounded">
                        <small class="text-muted">Company</small>
                        <h6 class="mb-0">{{ $cashFlow->company->name }}</h6>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="p-3 bg-light rounded">
                        <small class="text-muted">Project</small>
                        <h6 class="mb-0">{{ $cashFlow->project->name }}</h6>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="p-3 bg-light rounded">
                        <small class="text-muted">Year</small>
                        <h6 class="mb-0">{{ $cashFlow->year }}</h6>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="p-3 bg-light rounded">
                        <small class="text-muted">Created By</small>
                        <h6 class="mb-0">{{ $cashFlow->created_by }}</h6>
                    </div>
                </div>
            </div>

            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead class="table-light">
                        <tr>
                            <th rowspan="2" width="180">Particulars</th>
                            @foreach($monthlyTotals as $month => $data)
                                <th colspan="2" class="text-center">{{ $months[$month] }}</th>
                            @endforeach
                            <th colspan="2" class="text-center bg-primary text-white">Total</th>
                        </tr>
                        <tr>
                            @foreach($monthlyTotals as $month => $data)
                                <th class="text-center" style="font-size: 0.85rem;">Budget</th>
                                <th class="text-center" style="font-size: 0.85rem;">Actual</th>
                            @endforeach
                            <th class="text-center bg-primary text-white" style="font-size: 0.85rem;">Budget</th>
                            <th class="text-center bg-primary text-white" style="font-size: 0.85rem;">Actual</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Cash Inflows -->
                        @if($inflowItems->count() > 0)
                            <tr class="table-success">
                                <td colspan="{{ 2 + count($monthlyTotals) * 2 + 2 }}"><strong>Cash Inflows</strong></td>
                            </tr>

                            @foreach($inflowItems as $particularName => $items)
                                @php
                                    $totalBudget = 0;
                                    $totalActual = 0;
                                @endphp
                                <tr>
                                    <td>{{ $particularName }}</td>
                                    @foreach($monthlyTotals as $month => $data)
                                        @php
                                            $item = $items->firstWhere('month', $month);
                                            $budget = $item ? $item->budget : 0;
                                            $actual = $item ? $item->actual : 0;
                                            $totalBudget += $budget;
                                            $totalActual += $actual;
                                        @endphp
                                        <td class="text-end">{{ number_format($budget, 2) }}</td>
                                        <td class="text-end">{{ number_format($actual, 2) }}</td>
                                    @endforeach
                                    <td class="text-end bg-light"><strong>{{ number_format($totalBudget, 2) }}</strong></td>
                                    <td class="text-end bg-light"><strong>{{ number_format($totalActual, 2) }}</strong></td>
                                </tr>
                            @endforeach

                            <tr class="table-info">
                                <td><strong>Total Inflows</strong></td>
                                @php
                                    $grandTotalInflowBudget = 0;
                                    $grandTotalInflowActual = 0;
                                @endphp
                                @foreach($monthlyTotals as $month => $data)
                                    @php
                                        $grandTotalInflowBudget += $data['inflow_budget'];
                                        $grandTotalInflowActual += $data['inflow_actual'];
                                    @endphp
                                    <td class="text-end"><strong>{{ number_format($data['inflow_budget'], 2) }}</strong></td>
                                    <td class="text-end"><strong>{{ number_format($data['inflow_actual'], 2) }}</strong></td>
                                @endforeach
                                <td class="text-end bg-info text-white"><strong>{{ number_format($grandTotalInflowBudget, 2) }}</strong></td>
                                <td class="text-end bg-info text-white"><strong>{{ number_format($grandTotalInflowActual, 2) }}</strong></td>
                            </tr>
                        @endif

                        <!-- Cash Outflows -->
                        @if($outflowItems->count() > 0)
                            <tr class="table-danger">
                                <td colspan="{{ 2 + count($monthlyTotals) * 2 + 2 }}"><strong>Cash Outflows</strong></td>
                            </tr>

                            @foreach($outflowItems as $particularName => $items)
                                @php
                                    $totalBudget = 0;
                                    $totalActual = 0;
                                @endphp
                                <tr>
                                    <td>{{ $particularName }}</td>
                                    @foreach($monthlyTotals as $month => $data)
                                        @php
                                            $item = $items->firstWhere('month', $month);
                                            $budget = $item ? $item->budget : 0;
                                            $actual = $item ? $item->actual : 0;
                                            $totalBudget += $budget;
                                            $totalActual += $actual;
                                        @endphp
                                        <td class="text-end">{{ number_format($budget, 2) }}</td>
                                        <td class="text-end">{{ number_format($actual, 2) }}</td>
                                    @endforeach
                                    <td class="text-end bg-light"><strong>{{ number_format($totalBudget, 2) }}</strong></td>
                                    <td class="text-end bg-light"><strong>{{ number_format($totalActual, 2) }}</strong></td>
                                </tr>
                            @endforeach

                            <tr class="table-info">
                                <td><strong>Total Outflows</strong></td>
                                @php
                                    $grandTotalOutflowBudget = 0;
                                    $grandTotalOutflowActual = 0;
                                @endphp
                                @foreach($monthlyTotals as $month => $data)
                                    @php
                                        $grandTotalOutflowBudget += $data['outflow_budget'];
                                        $grandTotalOutflowActual += $data['outflow_actual'];
                                    @endphp
                                    <td class="text-end"><strong>{{ number_format($data['outflow_budget'], 2) }}</strong></td>
                                    <td class="text-end"><strong>{{ number_format($data['outflow_actual'], 2) }}</strong></td>
                                @endforeach
                                <td class="text-end bg-warning"><strong>{{ number_format($grandTotalOutflowBudget, 2) }}</strong></td>
                                <td class="text-end bg-warning"><strong>{{ number_format($grandTotalOutflowActual, 2) }}</strong></td>
                            </tr>
                        @endif

                        <!-- Net Cash Flow -->
                        <tr class="table-primary">
                            <td><strong>Net Cash Flow</strong></td>
                            @php
                                $grandNetBudget = 0;
                                $grandNetActual = 0;
                            @endphp
                            @foreach($monthlyTotals as $month => $data)
                                @php
                                    $grandNetBudget += $data['net_budget'];
                                    $grandNetActual += $data['net_actual'];
                                @endphp
                                <td class="text-end" style="color: {{ $data['net_budget'] < 0 ? 'red' : 'green' }}">
                                    <strong>{{ number_format($data['net_budget'], 2) }}</strong>
                                </td>
                                <td class="text-end" style="color: {{ $data['net_actual'] < 0 ? 'red' : 'green' }}">
                                    <strong>{{ number_format($data['net_actual'], 2) }}</strong>
                                </td>
                            @endforeach
                            <td class="text-end bg-primary text-white" style="color: {{ $grandNetBudget < 0 ? '#ffcccc' : '#ccffcc' }} !important">
                                <strong>{{ number_format($grandNetBudget, 2) }}</strong>
                            </td>
                            <td class="text-end bg-primary text-white" style="color: {{ $grandNetActual < 0 ? '#ffcccc' : '#ccffcc' }} !important">
                                <strong>{{ number_format($grandNetActual, 2) }}</strong>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="mt-4 p-3 bg-light rounded">
                <div class="row">
                    <div class="col-md-6">
                        <p class="mb-1"><strong>Created:</strong> {{ $cashFlow->created_at->format('M d, Y h:i A') }}</p>
                        <p class="mb-0"><strong>Last Updated:</strong> {{ $cashFlow->updated_at->format('M d, Y h:i A') }}</p>
                    </div>
                    <div class="col-md-6 text-md-end">
                        <p class="mb-0"><strong>Total Items:</strong> {{ $cashFlow->items->count() }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
