@extends('layouts.app')

@section('title', 'Companies')
@section('page-title', 'Companies Management')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="table-card">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h5 class="mb-0">All Companies</h5>
                <a href="{{ route('companies.create') }}" class="btn btn-primary-custom btn-custom">
                    <i class="bi bi-plus-circle me-2"></i>Add Company
                </a>
            </div>

            @if($companies->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover" id="companiesTable">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Description</th>
                                <th>Projects</th>
                                <th>Cash Flows</th>
                                <th>Created</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($companies as $company)
                            <tr>
                                <td><strong>#{{ $company->id }}</strong></td>
                                <td>{{ $company->name }}</td>
                                <td>{{ Str::limit($company->description ?? 'N/A', 50) }}</td>
                                <td><span class="badge bg-info">{{ $company->projects_count }}</span></td>
                                <td><span class="badge bg-success">{{ $company->cash_flows_count }}</span></td>
                                <td>{{ $company->created_at->format('M d, Y') }}</td>
                                <td>
                                    <a href="{{ route('companies.edit', $company) }}" class="btn btn-sm btn-warning">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <form action="{{ route('companies.destroy', $company) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-building" style="font-size: 3rem; color: #cbd5e1;"></i>
                    <p class="text-muted mt-3">No companies found</p>
                    <a href="{{ route('companies.create') }}" class="btn btn-primary-custom btn-custom mt-2">
                        <i class="bi bi-plus-circle me-2"></i>Create Your First Company
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('#companiesTable').DataTable({
            responsive: true,
            order: [[0, 'desc']],
            pageLength: 10,
            language: {
                search: "Search companies:"
            }
        });
    });
</script>
@endpush
