@extends('layouts.app')

@section('title', 'Dashboard - Cash Flow Management')
@section('page-title', 'Dashboard')

@section('content')
<div class="row g-4">
    <div class="col-12 col-sm-6 col-lg-3">
        <div class="stat-card primary">
            <div class="icon">
                <i class="bi bi-building"></i>
            </div>
            <h3>{{ $totalCompanies }}</h3>
            <p>Total Companies</p>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-lg-3">
        <div class="stat-card success">
            <div class="icon">
                <i class="bi bi-folder"></i>
            </div>
            <h3>{{ $totalProjects }}</h3>
            <p>Total Projects</p>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-lg-3">
        <div class="stat-card warning">
            <div class="icon">
                <i class="bi bi-graph-up-arrow"></i>
            </div>
            <h3>{{ $totalCashFlows }}</h3>
            <p>Cash Flows Created</p>
        </div>
    </div>
    <div class="col-12 col-sm-6 col-lg-3">
        <div class="stat-card info">
            <div class="icon">
                <i class="bi bi-cash-coin"></i>
            </div>
            <h3>{{ number_format($netCashFlow) }}</h3>
            <p>Net Cash Flow</p>
        </div>
    </div>
</div>

<div class="row mt-4">
    <div class="col-12">
        <div class="table-card">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0">Recent Cash Flows</h5>
                <a href="{{ route('cash-flows.create') }}" class="btn btn-primary-custom btn-custom">
                    <i class="bi bi-plus-circle me-2"></i>Create New
                </a>
            </div>

            @if($recentCashFlows->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Company</th>
                                <th>Project</th>
                                <th>Year</th>
                                <th>Created By</th>
                                <th>Created At</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($recentCashFlows as $cashFlow)
                            <tr>
                                <td><strong>#{{ $cashFlow->id }}</strong></td>
                                <td>{{ $cashFlow->company->name }}</td>
                                <td>{{ $cashFlow->project->name }}</td>
                                <td><span class="badge bg-primary">{{ $cashFlow->year }}</span></td>
                                <td>{{ $cashFlow->created_by }}</td>
                                <td>{{ $cashFlow->created_at->format('M d, Y') }}</td>
                                <td>
                                    <a href="{{ route('cash-flows.show', $cashFlow) }}" class="btn btn-sm btn-info">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-inbox" style="font-size: 3rem; color: #cbd5e1;"></i>
                    <p class="text-muted mt-3">No cash flows created yet</p>
                    <a href="{{ route('cash-flows.create') }}" class="btn btn-primary-custom btn-custom mt-2">
                        Create Your First Cash Flow
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>

<div class="row mt-4">
    <div class="col-md-6">
        <div class="table-card">
            <h5 class="mb-3">Quick Actions</h5>
            <div class="list-group list-group-flush">
                <a href="{{ route('companies.create') }}" class="list-group-item list-group-item-action d-flex align-items-center">
                    <i class="bi bi-plus-circle me-3 text-primary" style="font-size: 1.5rem;"></i>
                    <div>
                        <h6 class="mb-0">Add New Company</h6>
                        <small class="text-muted">Create a new company profile</small>
                    </div>
                </a>
                <a href="{{ route('projects.create') }}" class="list-group-item list-group-item-action d-flex align-items-center">
                    <i class="bi bi-folder-plus me-3 text-success" style="font-size: 1.5rem;"></i>
                    <div>
                        <h6 class="mb-0">Add New Project</h6>
                        <small class="text-muted">Start tracking a new project</small>
                    </div>
                </a>
                <a href="{{ route('particulars.create') }}" class="list-group-item list-group-item-action d-flex align-items-center">
                    <i class="bi bi-list-check me-3 text-warning" style="font-size: 1.5rem;"></i>
                    <div>
                        <h6 class="mb-0">Add Particular</h6>
                        <small class="text-muted">Define inflow/outflow items</small>
                    </div>
                </a>
                <a href="{{ route('cash-flows.create') }}" class="list-group-item list-group-item-action d-flex align-items-center">
                    <i class="bi bi-graph-up me-3 text-info" style="font-size: 1.5rem;"></i>
                    <div>
                        <h6 class="mb-0">Create Cash Flow</h6>
                        <small class="text-muted">Generate new cash flow statement</small>
                    </div>
                </a>
            </div>
        </div>
    </div>

    <div class="col-md-6 mt-4 mt-md-0">
        <div class="table-card">
            <h5 class="mb-3">System Overview</h5>
            <div class="row g-3">
                <div class="col-6">
                    <div class="p-3 bg-light rounded">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="text-muted mb-1 small">Active Projects</p>
                                <h4 class="mb-0">{{ \App\Models\Project::where('status', 'Active')->count() }}</h4>
                            </div>
                            <i class="bi bi-check-circle text-success" style="font-size: 2rem;"></i>
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="p-3 bg-light rounded">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="text-muted mb-1 small">Inactive Projects</p>
                                <h4 class="mb-0">{{ \App\Models\Project::where('status', 'Inactive')->count() }}</h4>
                            </div>
                            <i class="bi bi-x-circle text-danger" style="font-size: 2rem;"></i>
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="p-3 bg-light rounded">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="text-muted mb-1 small">Inflow Items</p>
                                <h4 class="mb-0">{{ \App\Models\Particular::where('type', 'Inflow')->count() }}</h4>
                            </div>
                            <i class="bi bi-arrow-down-circle text-success" style="font-size: 2rem;"></i>
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="p-3 bg-light rounded">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="text-muted mb-1 small">Outflow Items</p>
                                <h4 class="mb-0">{{ \App\Models\Particular::where('type', 'Outflow')->count() }}</h4>
                            </div>
                            <i class="bi bi-arrow-up-circle text-danger" style="font-size: 2rem;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
