@extends('layouts.app')

@section('title', 'Particulars')
@section('page-title', 'Particulars Management')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="table-card">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h5 class="mb-0">All Particulars</h5>
                <a href="{{ route('particulars.create') }}" class="btn btn-primary-custom btn-custom">
                    <i class="bi bi-plus-circle me-2"></i>Add Particular
                </a>
            </div>

            @if($particulars->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover" id="particularsTable">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Company</th>
                                <th>Type</th>
                                <th>Status</th>
                                <th>Description</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($particulars as $particular)
                            <tr>
                                <td><strong>#{{ $particular->id }}</strong></td>
                                <td>{{ $particular->name }}</td>
                                <td>{{ $particular->company->name }}</td>
                                <td>
                                    @if($particular->type == 'Inflow')
                                        <span class="badge bg-success"><i class="bi bi-arrow-down-circle"></i> Inflow</span>
                                    @else
                                        <span class="badge bg-danger"><i class="bi bi-arrow-up-circle"></i> Outflow</span>
                                    @endif
                                </td>
                                <td>
                                    @if($particular->status == 'Active')
                                        <span class="badge bg-primary">Active</span>
                                    @else
                                        <span class="badge bg-secondary">Inactive</span>
                                    @endif
                                </td>
                                <td>{{ Str::limit($particular->description ?? 'N/A', 40) }}</td>
                                <td>
                                    <a href="{{ route('particulars.edit', $particular) }}" class="btn btn-sm btn-warning">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <form action="{{ route('particulars.destroy', $particular) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-list-check" style="font-size: 3rem; color: #cbd5e1;"></i>
                    <p class="text-muted mt-3">No particulars found</p>
                    <a href="{{ route('particulars.create') }}" class="btn btn-primary-custom btn-custom mt-2">
                        <i class="bi bi-plus-circle me-2"></i>Create Your First Particular
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('#particularsTable').DataTable({
            responsive: true,
            order: [[0, 'desc']],
            pageLength: 10
        });
    });
</script>
@endpush
