@extends('layouts.app')

@section('title', 'Projects')
@section('page-title', 'Projects Management')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="table-card">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h5 class="mb-0">All Projects</h5>
                <a href="{{ route('projects.create') }}" class="btn btn-primary-custom btn-custom">
                    <i class="bi bi-plus-circle me-2"></i>Add Project
                </a>
            </div>

            @if($projects->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover" id="projectsTable">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Project Name</th>
                                <th>Company</th>
                                <th>Status</th>
                                <th>Description</th>
                                <th>Created</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($projects as $project)
                            <tr>
                                <td><strong>#{{ $project->id }}</strong></td>
                                <td>{{ $project->name }}</td>
                                <td>{{ $project->company->name }}</td>
                                <td>
                                    @if($project->status == 'Active')
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-secondary">Inactive</span>
                                    @endif
                                </td>
                                <td>{{ Str::limit($project->description ?? 'N/A', 40) }}</td>
                                <td>{{ $project->created_at->format('M d, Y') }}</td>
                                <td>
                                    <a href="{{ route('projects.edit', $project) }}" class="btn btn-sm btn-warning">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <form action="{{ route('projects.destroy', $project) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-folder" style="font-size: 3rem; color: #cbd5e1;"></i>
                    <p class="text-muted mt-3">No projects found</p>
                    <a href="{{ route('projects.create') }}" class="btn btn-primary-custom btn-custom mt-2">
                        <i class="bi bi-plus-circle me-2"></i>Create Your First Project
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('#projectsTable').DataTable({
            responsive: true,
            order: [[0, 'desc']],
            pageLength: 10
        });
    });
</script>
@endpush
