<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\ParticularController;
use App\Http\Controllers\CashFlowController;

Route::get('/', [DashboardController::class, 'index'])->name('dashboard');

Route::resource('companies', CompanyController::class);
Route::resource('projects', ProjectController::class);
Route::resource('particulars', ParticularController::class);
Route::resource('cash-flows', CashFlowController::class);

Route::get('/api/projects/company/{companyId}', [ProjectController::class, 'getByCompany']);
Route::get('/api/particulars/company/{companyId}', [ParticularController::class, 'getByCompany']);
